# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def tranquil_serenity(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Early rounds (1-3)
    if current_round <= 3:
        if current_round == 1:
            return "C"
        return opp_history[-1]
    
    # Mid rounds (4-7)
    if current_round <= 7:
        if "mirror" in opponent_program_code.lower() or "random" in opponent_program_code.lower() or "forgiveness" in opponent_program_code.lower():
            if opp_history[-1] == "D":
                return "D" if random.random() < 0.9 else "C"
            else:
                return "C" if random.random() < 0.6 else "D"
        else:
            if opp_history[-1] == "D":
                return "D" if random.random() < 0.8 else "C"
            else:
                return "C" if random.random() < 0.6 else "D"
    
    # Late rounds (8-10)
    # Calculate cumulative payoffs (simplified estimation)
    my_score = sum(1 if m == "C" and o == "C" else (5 if m == "D" and o == "C" else 0 if m == "C" and o == "D" else 3) for m, o in zip(my_history, opp_history))
    opp_score = sum(1 if o == "C" and m == "C" else (5 if o == "D" and m == "C" else 0 if o == "C" and m == "D" else 3) for o, m in zip(opp_history, my_history))
    
    if my_score < opp_score:
        return "D"
    else:
        return "D" if current_round % 2 == 0 else "C"